"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));
var _allHeaders = require("./all-headers");
var _errors = require("./errors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// const OPTION = {
//   WITH_RECOMPILE: 0x01,
//   NO_METADATA: 0x02,
//   REUSE_METADATA: 0x04
// };

const STATUS = {
  BY_REF_VALUE: 0x01,
  DEFAULT_VALUE: 0x02
};

/*
  s2.2.6.5
 */
class RpcRequestPayload {
  constructor(procedure, parameters, txnDescriptor, options, collation) {
    this.procedure = procedure;
    this.parameters = parameters;
    this.options = options;
    this.txnDescriptor = txnDescriptor;
    this.collation = collation;
  }
  [Symbol.iterator]() {
    return this.generateData();
  }
  *generateData() {
    const buffer = new _writableTrackingBuffer.default(500);
    if (this.options.tdsVersion >= '7_2') {
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
    }
    if (typeof this.procedure === 'string') {
      buffer.writeUsVarchar(this.procedure);
    } else {
      buffer.writeUShort(0xFFFF);
      buffer.writeUShort(this.procedure);
    }
    const optionFlags = 0;
    buffer.writeUInt16LE(optionFlags);
    yield buffer.data;
    const parametersLength = this.parameters.length;
    for (let i = 0; i < parametersLength; i++) {
      yield* this.generateParameterData(this.parameters[i]);
    }
  }
  toString(indent = '') {
    return indent + ('RPC Request - ' + this.procedure);
  }
  *generateParameterData(parameter) {
    const buffer = new _writableTrackingBuffer.default(1 + 2 + Buffer.byteLength(parameter.name, 'ucs-2') + 1);
    if (parameter.name) {
      buffer.writeBVarchar('@' + parameter.name);
    } else {
      buffer.writeBVarchar('');
    }
    let statusFlags = 0;
    if (parameter.output) {
      statusFlags |= STATUS.BY_REF_VALUE;
    }
    buffer.writeUInt8(statusFlags);
    yield buffer.data;
    const param = {
      value: parameter.value
    };
    const type = parameter.type;
    if ((type.id & 0x30) === 0x20) {
      if (parameter.length) {
        param.length = parameter.length;
      } else if (type.resolveLength) {
        param.length = type.resolveLength(parameter);
      }
    }
    if (parameter.precision) {
      param.precision = parameter.precision;
    } else if (type.resolvePrecision) {
      param.precision = type.resolvePrecision(parameter);
    }
    if (parameter.scale) {
      param.scale = parameter.scale;
    } else if (type.resolveScale) {
      param.scale = type.resolveScale(parameter);
    }
    if (this.collation) {
      param.collation = this.collation;
    }
    yield type.generateTypeInfo(param, this.options);
    yield type.generateParameterLength(param, this.options);
    try {
      yield* type.generateParameterData(param, this.options);
    } catch (error) {
      throw new _errors.InputError(`Input parameter '${parameter.name}' could not be validated`, {
        cause: error
      });
    }
  }
}
var _default = exports.default = RpcRequestPayload;
module.exports = RpcRequestPayload;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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