"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _moneyn = _interopRequireDefault(require("./moneyn"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallMoney = {
  id: 0x7A,
  type: 'MONEY4',
  name: 'SmallMoney',
  declaration: function () {
    return 'smallmoney';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x04]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(parameter.value * 10000, 0);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    value = parseFloat(value);
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    if (value < -214748.3648 || value > 214748.3647) {
      throw new TypeError('Value must be between -214748.3648 and 214748.3647.');
    }
    return value;
  }
};
var _default = exports.default = SmallMoney;
module.exports = SmallMoney;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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