"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _core = require("@js-joda/core");
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EPOCH_DATE = _core.LocalDate.ofYearDay(1, 1);
const NULL_LENGTH = Buffer.from([0x00]);
const DateTime2 = {
  id: 0x2A,
  type: 'DATETIME2N',
  name: 'DateTime2',
  declaration: function (parameter) {
    return 'datetime2(' + this.resolveScale(parameter) + ')';
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else if (parameter.value === null) {
      return 0;
    } else {
      return 7;
    }
  },
  generateTypeInfo(parameter, _options) {
    return Buffer.from([this.id, parameter.scale]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        return Buffer.from([0x06]);
      case 3:
      case 4:
        return Buffer.from([0x07]);
      case 5:
      case 6:
      case 7:
        return Buffer.from([0x08]);
      default:
        throw new Error('invalid scale');
    }
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const value = parameter.value;
    let scale = parameter.scale;
    const buffer = new _writableTrackingBuffer.default(16);
    scale = scale;
    let timestamp;
    if (options.useUTC) {
      timestamp = ((value.getUTCHours() * 60 + value.getUTCMinutes()) * 60 + value.getUTCSeconds()) * 1000 + value.getUTCMilliseconds();
    } else {
      timestamp = ((value.getHours() * 60 + value.getMinutes()) * 60 + value.getSeconds()) * 1000 + value.getMilliseconds();
    }
    timestamp = timestamp * Math.pow(10, scale - 3);
    timestamp += (value.nanosecondDelta != null ? value.nanosecondDelta : 0) * Math.pow(10, scale);
    timestamp = Math.round(timestamp);
    switch (scale) {
      case 0:
      case 1:
      case 2:
        buffer.writeUInt24LE(timestamp);
        break;
      case 3:
      case 4:
        buffer.writeUInt32LE(timestamp);
        break;
      case 5:
      case 6:
      case 7:
        buffer.writeUInt40LE(timestamp);
    }
    let date;
    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }
    const days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    buffer.writeUInt24LE(days);
    yield buffer.data;
  },
  validate: function (value, collation, options) {
    if (value == null) {
      return null;
    }
    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }
    value = value;
    let year;
    if (options && options.useUTC) {
      year = value.getUTCFullYear();
    } else {
      year = value.getFullYear();
    }
    if (year < 1 || year > 9999) {
      throw new TypeError('Out of range.');
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }
    return value;
  }
};
var _default = exports.default = DateTime2;
module.exports = DateTime2;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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