"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _iconvLite = _interopRequireDefault(require("iconv-lite"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const Char = {
  id: 0xAF,
  type: 'BIGCHAR',
  name: 'Char',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;
    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }
    if (length < this.maximumLength) {
      return 'char(' + length + ')';
    } else {
      return 'char(' + this.maximumLength + ')';
    }
  },
  // ParameterData<any> is temporary solution. TODO: need to understand what type ParameterData<...> can be.
  resolveLength: function (parameter) {
    const value = parameter.value;
    if (parameter.length != null) {
      return parameter.length;
    } else if (value != null) {
      return value.length || 1;
    } else {
      return this.maximumLength;
    }
  },
  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);
    buffer.writeUInt16LE(parameter.length, 1);
    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }
    return buffer;
  },
  generateParameterLength(parameter, options) {
    const value = parameter.value;
    if (value == null) {
      return NULL_LENGTH;
    }
    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(value.length, 0);
    return buffer;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    yield Buffer.from(parameter.value, 'ascii');
  },
  validate: function (value, collation) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }
    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }
    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }
    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = exports.default = Char;
module.exports = Char;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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