/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../AuthFlowState.js";
import { AUTH_METHOD_REGISTRATION_COMPLETED_STATE_TYPE } from "../../AuthFlowStateTypes.js";

/**
 * State indicating that the auth method registration flow has completed successfully.
 */
export class AuthMethodRegistrationCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = AUTH_METHOD_REGISTRATION_COMPLETED_STATE_TYPE;
}
