const bcrypt = require('bcrypt');

const PASSWORD_BCRYPT_COST = 10;

module.exports = {

  //  SECURE PASSWORD HASH (replacement of Encrypt)
  encrypt: (plainText) => {
    if (!plainText) return plainText;
    const salt = bcrypt.genSaltSync(PASSWORD_BCRYPT_COST);
    return bcrypt.hashSync(plainText, salt);
  },

  //  PASSWORD VERIFY (login time)
  compare: (plainText, hash) => {
    if (!plainText || !hash) return false;
    return bcrypt.compareSync(plainText, hash);
  }

};
