const sql = require('mssql');
const dbconfig = require('../db');

const poolPromise = new sql.ConnectionPool(dbconfig)
  .connect()
  .then(pool => {
    console.log('MSSQL connected');
    return pool;
  })
  .catch(err => {
    console.error('MSSQL connection failed', err);
    throw err;
  });

module.exports = {
  sql,
  poolPromise
};
