var { failure_callback, 
    checkVar,
    isValidEmail
} = require('./common');


module.exports = {


    tbl_user_id_val: function (req, res, next) {

        try {
            const {tbl_user_id } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    tbl_user_id_pagination_validation: function (req, res, next) {

        try {
            const { tbl_user_id, pagesize, pagenumber } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400]);
            }

            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400]);
            }

            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    Login_signup_val: function (req, res, next) {

        try {
            const {mobile, firebase_token} = req.body;
            

            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            if (checkVar(firebase_token)) {
                return failure_callback(res, ['firebase_token is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Login_signup_otp_verify_API: function (req, res, next) {

        try {
            const {mobile, otp } = req.body

            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            if (checkVar(otp)) {
                return failure_callback(res, ['otp is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    
    subcategory_val: function (req, res, next) {

        try {
            const {tbl_category_id } = req.body

            if (checkVar(tbl_category_id)) {
                return failure_callback(res, ['tbl_category_id is required', 400]);
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },
    mobile_otp_verify_val: function (req, res, next) {

        try {
            const { mobile, otp } = req.body;

            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400]);
            }
            if (checkVar(otp)) {
                return failure_callback(res, ['otp is required', 400]);
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },







}