const sql = require('mssql');
const {poolPromise} = require('../../config/mssql'); // your poolPromise

module.exports = {

  //  GET USDT RATE
  get_usdt_rate_API: async (req, res) => {
    try {
      const pool = await poolPromise;

      const result = await pool.request()
        .query("EXEC sp_setUSDTRate 'Select'");

      if (result.recordset.length > 0) {
        return res.json({
          status: true,
          message: 'USDT Rate fetched successfully',
          data: result.recordset[0]
        });
      }

      return res.json({
        status: false,
        message: 'No data found',
        data: []
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  //  UPDATE USDT RATE
  update_usdt_rate_API: async (req, res) => {
    try {
      const { usdtRate } = req.body;

      if (!usdtRate) {
        return res.json({
          status: false,
          message: 'Enter USDT Rate',
          data: []
        });
      }

      const pool = await poolPromise;

      await pool.request()
        .query(`EXEC sp_setUSDTRate 'Update','${usdtRate}'`);

      return res.json({
        status: true,
        message: 'Update successfully',
        data: []
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  }

};
