const sql = require('mssql');
const { poolPromise } = require('../../config/mssql');
const HashingHelper = require('../../helpers/HashingHelper');

module.exports = {

  // get_active_deactive_users_API: async (req, res) => {
  //   try {

  //     const pool = await poolPromise;

  //     const result = await pool.request()
  //       .query("EXEC Sp_Getuser_activedeactive");

  //     if (result.recordset.length > 0) {
  //       return res.json({
  //         status: true,
  //         message: 'User list fetched successfully',
  //         data: result.recordset
  //       });
  //     }

  //     return res.json({
  //       status: false,
  //       message: 'No record found',
  //       data: []
  //     });

  //   } catch (err) {
  //     return res.json({
  //       status: false,
  //       message: err.message,
  //       data: []
  //     });
  //   }
  // },


  get_active_deactive_users_API: async (req, res) => {
    try {

      const {
        page = 1,
        limit = 5,
        search = '',
        fromDate = '',
        toDate = ''
      } = req.query;

      const offset = (page - 1) * limit;

      let whereCondition = ` WHERE mm.regno = ml.regno AND mm.kid <> 0 `;

      //  SEARCH
      if (search) {
        whereCondition += `
          AND (
            mm.loginid LIKE '%${search}%'
            OR mm.fname LIKE '%${search}%'
            OR mm.mobile LIKE '%${search}%'
            OR mm.emailid LIKE '%${search}%'
          )
        `;
      }

      //  DATE FILTER (yyyy-MM-dd)
      if (fromDate && toDate) {
        whereCondition += `
          AND CONVERT(date, mm.topupdate) 
          BETWEEN '${fromDate}' AND '${toDate}'
        `;
      }

      const query = `
        SELECT 
          ROW_NUMBER() OVER (ORDER BY mm.regno DESC) AS rowno,
          ml.regno,
          mm.loginid,
          mm.fname,
          mm.mobile,
          mm.emailid,
          ml.Secret_ans AS remark,

          CASE 
            WHEN ml.active = 0 THEN '<b style="color:Red">Block</b>' 
            ELSE '<b style="color:Green">Unblock</b>' 
          END AS active,

          CASE 
            WHEN ml.active = 1 THEN 'Block' 
            ELSE 'Unblock' 
          END AS actives,

          CASE 
            WHEN mm.active = 1 THEN 'btn btn-danger' 
            ELSE 'btn btn-success' 
          END AS cssclass,

          CASE 
            WHEN mm.kid <> 0 THEN 'Paid' 
            ELSE 'Unpaid' 
          END AS paidstatus,

          mm.kitPV AS kitBV,

          CASE 
            WHEN mm.kid = 0 THEN '' 
            ELSE mm.kitprice 
          END AS kitstatus,

          FORMAT(mm.topupdate, 'dd-MM-yyyy') AS doa

        FROM member_login ml
        JOIN member_master mm ON mm.regno = ml.regno
        ${whereCondition}
        ORDER BY mm.regno DESC
        OFFSET ${offset} ROWS FETCH NEXT ${limit} ROWS ONLY
      `;

      const countQuery = `
        SELECT COUNT(*) AS total
        FROM member_login ml
        JOIN member_master mm ON mm.regno = ml.regno
        ${whereCondition}
      `;

      const pool = await poolPromise;

      const result = await pool.request().query(query);
      const totalResult = await pool.request().query(countQuery);


      return res.json({
        status: true,
        message: 'User list fetched successfully',
        data: {
          list: result.recordset,
          total: totalResult.recordset[0].total,
          page: Number(page),
          limit: Number(limit)
        }
      });


    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  block_unblock_user_API: async (req, res) => {
    try {

      const { regno, action, remark } = req.body;

      if (!regno || !action) {
        return res.json({
          status: false,
          message: 'RegNo and Action required',
          data: []
        });
      }

      const activeStatus = action === 'Block' ? 0 : 1;

      const query = `
        UPDATE member_login
        SET 
          Active = @active,
          Secret_ans = @remark
        WHERE regno = @regno
      `;

      const pool = await poolPromise;

      await pool.request()
        .input('active', sql.Int, activeStatus)
        .input('remark', sql.VarChar, remark || '')
        .input('regno', sql.Int, regno)
        .query(query);

      return res.json({
        status: true,
        message: `User ${action}ed successfully`,
        data: []
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  // here somthing issue
  get_account_statement_API: async (req, res) => {
    try {

      const {
        page = 1,
        limit = 4
      } = req.body;   // 👈 body se aa raha hai (same as all members)

      const pool = await poolPromise;

      // 🔹 SIMPLE procedure call (NO PARAMETERS)
      const result = await pool.request()
        .query('EXEC sp_accountStatement');

      let data = result.recordset || [];

      // -------------------------
      // PAGINATION (NODE SIDE)
      // -------------------------
      const totalRecords = data.length;
      const startIndex = (page - 1) * limit;
      const endIndex = page * limit;

      const paginatedData = data.slice(startIndex, endIndex);

      return res.json({
        status: true,
        message: 'Account statement fetched successfully',
        totalRecords,
        page,
        limit,
        data: paginatedData
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  get_all_members_API: async (req, res) => {
    try {

      const {
        type = 1,              // 1 = all, 2 = search
        searchBy = '',         // Registration | Activation
        fromDate = '',         // dd-MM-yyyy
        toDate = '',           // dd-MM-yyyy
        page = 1,
        limit = 10,
      } = req.body;

      const pool = await poolPromise;

      const request = pool.request()
        .input('type', sql.Int, type)
        .input('searchby', sql.NVarChar, searchBy)
        .input('fromdate', sql.NVarChar, fromDate)
        .input('todate', sql.NVarChar, toDate);

      const result = await request.execute('Sp_All_User');

      let data = result.recordset || [];

      // -------------------------
      // PAGINATION (NODE SIDE)
      // -------------------------
      const startIndex = (page - 1) * limit;
      const endIndex = page * limit;

      const paginatedData = data.slice(startIndex, endIndex);

      return res.json({
        status: true,
        message: 'Members fetched successfully',
        totalRecords: data.length,
        page,
        limit,
        data: paginatedData
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  get_wallet_details: async (req, res) => {
    try {
      let {
        page = 1,
        pageSize = 5,
        search = ''
      } = req.body;   

      page = parseInt(page);
      pageSize = parseInt(pageSize);

      const pool = await poolPromise;

      // 1 Call SAME OLD PROCEDURE
      const result = await pool.request()
        .execute('Sp_getwallet_details2');

      let rows = result.recordset || [];

      // 2 SEARCH (Node-side)
      if (search && search.trim() !== '') {
        const keyword = search.toLowerCase();
        rows = rows.filter(r =>
          (r.userid && r.userid.toLowerCase().includes(keyword)) ||
          (r.username && r.username.toLowerCase().includes(keyword))
        );
      }

      // 3️ TOTAL RECORDS (after search)
      const totalRecords = rows.length;

      // 4️ PAGINATION (Node-side)
      const startIndex = (page - 1) * pageSize;
      const paginatedData = rows.slice(startIndex, startIndex + pageSize);

      // 5️⃣ TOTAL MAIN WALLET (like ASPX)
      const totalMainWallet = rows.reduce((sum, r) => {
        return sum + (r.netbal || 0);
      }, 0);

      return res.json({
        status: true,
        message: 'Wallet details fetched successfully',
        page,
        pageSize,
        totalRecords,
        totalMainWallet: totalMainWallet.toFixed(2),
        data: paginatedData
      });

    } catch (err) {
      console.error(err);
      return res.json({
        status: false,
        message: err.message,
        data: []
      });
    }  
  },


  //issue here
  getUserByLoginId : async (req, res) => {
  try {
    const { loginId, action } = req.body;
    // action = AN | AID | MAD | MT | etc.

    if (!loginId) {
      return res.json({
        status: false,
        message: 'Login ID is required',
        data: null
      });
    }

    const pool = await poolPromise;

    // 1️⃣ Get regno
    const userResult = await pool.request()
      .input('loginid', sql.NVarChar, loginId)
      .query(`
        SELECT regno, loginid, mobile 
        FROM member_master WITH (NOLOCK)
        WHERE loginid = @loginid
      `);

    if (userResult.recordset.length === 0) {
      return res.json({
        status: false,
        message: 'Invalid Distributor ID / User Name',
        data: null
      });
    }

    const user = userResult.recordset[0];

    // 2 Decide redirect path (same logic as ASP.NET)
    const redirectMap = {
      AN: '/add-new',
      AID: '/account-upgrade',
      MAD: '/account-statement',
      MT: '/matrix',
      TTR: '/total-team-report',
      EW: '/ewallet',
      VP: '/view-profile',
      AC: '/account-details',
      PST: '/payout-statement'
      // jo-jo chahiye add karte jao
    };

    const redirectUrl = redirectMap[action] || '';

    return res.json({
      status: true,
      message: 'User found',
      data: {
        regno: user.regno,
        loginid: user.loginid,
        mobile: user.mobile,
        action,
        redirectUrl
      }
    });

  } catch (err) {
    return res.json({
      status: false,
      message: err.message,
      data: null
    });
  }
  },  

  //something issue here verify again this 
  // getActiveDeactiveUsers : async (req, res) => {
  //   try {
  //     const {
  //       page = 1,
  //       pageSize = 10,
  //       search = ''
  //     } = req.query;

  //     const pageNo = parseInt(page);
  //     const limit = parseInt(pageSize);
  //     const offset = (pageNo - 1) * limit;

  //     const pool = await poolPromise;

  //     // SAME PROCEDURE – NO CHANGE
  //     const result = await pool.request()
  //       .execute('Sp_user_incomeBlock');

  //     let rows = result.recordset || [];

  //     //  SEARCH (same like DataTable search)
  //     if (search) {
  //       const s = search.toLowerCase();
  //       rows = rows.filter(r =>
  //         (r.loginid && r.loginid.toLowerCase().includes(s)) ||
  //         (r.fname && r.fname.toLowerCase().includes(s)) ||
  //         (r.emailid && r.emailid.toLowerCase().includes(s))
  //       );
  //     }

  //     const totalRecords = rows.length;

  //     //  PAGINATION
  //     const paginatedData = rows.slice(offset, offset + limit);

  //     return res.json({
  //       status: true,
  //       message: 'User income block list fetched',
  //       data: paginatedData,
  //       pagination: {
  //         totalRecords,
  //         currentPage: pageNo,
  //         pageSize: limit,
  //         totalPages: Math.ceil(totalRecords / limit)
  //       }
  //     });

  //   } catch (err) {
  //     return res.json({
  //       status: false,
  //       message: err.message,
  //       data: []
  //     });
  //   }
  // },

  // blockUnblockMember : async (req, res) => {
  //   try {
  //     const { regno, type, action } = req.body;

  //     /*
  //       type   = roi | booster | level | salary
  //       action = block | unblock
  //     */

  //     if (!regno || !type || !action) {
  //       return res.json({
  //         status: false,
  //         message: 'Required fields missing',
  //       });
  //     }

  //     let query = '';

  //     // 🔹 SAME ASPX LOGIC
  //     if (type === 'roi') {
  //       query = action === 'block'
  //         ? 'update member_master set maxwlimit=1, oState=dateadd(mi,330,getutcdate()) where regno=@regno'
  //         : 'update member_master set maxwlimit=0 where regno=@regno';
  //     }

  //     else if (type === 'booster') {
  //       query = action === 'block'
  //         ? 'update member_master set kitBV=1 where regno=@regno'
  //         : 'update member_master set kitBV=0 where regno=@regno';
  //     }

  //     else if (type === 'level') {
  //       query = action === 'block'
  //         ? 'update member_master set directid=1 where regno=@regno'
  //         : 'update member_master set directid=0 where regno=@regno';
  //     }

  //     else if (type === 'salary') {
  //       query = action === 'block'
  //         ? 'update member_master set totalteam=1 where regno=@regno'
  //         : 'update member_master set totalteam=0 where regno=@regno';
  //     }

  //     else {
  //       return res.json({
  //         status: false,
  //         message: 'Invalid block type'
  //       });
  //     }

  //     const pool = await poolPromise;

  //     await pool.request()
  //       .input('regno', sql.Int, regno)
  //       .query(query);

  //     return res.json({
  //       status: true,
  //       message: `${type.toUpperCase()} successfully ${action}ed`
  //     });

  //   } catch (err) {
  //     return res.json({
  //       status: false,
  //       message: err.message
  //     });
  //   }
  // },


  getIncomeBlockUsers : async (req, res) => {
    try {
      const pool = await poolPromise;

      // query params
      const search = req.query.search ? req.query.search.toLowerCase() : "";
      const page = parseInt(req.query.page) || 1;
      const limit = parseInt(req.query.limit) || 4;

      const offset = (page - 1) * limit; 

      // call SAME procedure
      const result = await pool
        .request()
        .execute("Sp_user_incomeBlock");

      let rows = result.recordset;

      //  SEARCH FILTER (NO logic change)
      if (search) {
        rows = rows.filter(r =>
          (r.loginid && r.loginid.toLowerCase().includes(search)) ||
          (r.fname && r.fname.toLowerCase().includes(search)) ||
          (r.emailid && r.emailid.toLowerCase().includes(search))
        );
      }

      const totalRecords = rows.length;

      //  PAGINATION
      const paginatedData = rows.slice(offset, offset + limit);

      res.json({
        status: true,
        message: "Users fetched successfully",
        pagination: {
          totalRecords,
          currentPage: page,
          totalPages: Math.ceil(totalRecords / limit),
          limit
        },
        data: paginatedData
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message
      });
    }
  },

  incomeBlockAction : async (req, res) => {
    try {
      const { regno, action } = req.body;

      let query = "";

      switch (action) {

        case "ROI Block":
          query = `update member_master 
                  set maxwlimit=1,oState=dateadd(mi,330,getutcdate()) 
                  where regno=${regno}`;
          break;

        case "ROI Unblock":
          query = `update member_master set maxwlimit=0 where regno=${regno}`;
          break;

        case "Booster Block":
          query = `update member_master set kitBV=1 where regno=${regno}`;
          break;

        case "Booster Unblock":
          query = `update member_master set kitBV=0 where regno=${regno}`;
          break;

        case "Level Income Block":
          query = `update member_master set directid=1 where regno=${regno}`;
          break;

        case "Level Income Unblock":
          query = `update member_master set directid=0 where regno=${regno}`;
          break;

        case "Salary Block":
          query = `update member_master set totalteam=1 where regno=${regno}`;
          break;

        case "Salary Unblock":
          query = `update member_master set totalteam=0 where regno=${regno}`;
          break;

        default:
          return res.json({ status: false, message: "Invalid Action" });
      }

      const pool = await poolPromise;
      await pool.request().query(query);

      res.json({
        status: true,
        message: `${action} successfully`
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message
      });
    }
  },


  getCountries : async (req, res) => {
  try {
    const pool = await poolPromise;

    const result = await pool.request()
      .query("SELECT * FROM COUNTRY");

    return res.json({
      status: true,
      data: result.recordset
    });

  } catch (err) {
    return res.json({
      status: false,
      message: err.message
    });
  }
  },

  validateSponsor : async (req, res) => {
  try {
    const { loginid } = req.params;

    //  BLOCKED IDS (same logic)
    if (loginid === "PT205744" || loginid === "PT673868") {
      return res.json({
        status: false,
        message: "ID is block for Sponsor"
      });
    }

    const pool = await poolPromise;

    const result = await pool.request()
      .query(`EXEC spGetUserNameByLoginid '${loginid}'`);

    if (result.recordset.length > 0) {
      return res.json({
        status: true,
        sponsorName: result.recordset[0].Name
      });
    }

    return res.json({
      status: false,
      message: "Invalid Referral ID"
    });

  } catch (err) {
    return res.json({
      status: false,
      message: err.message
    });
  }
  },

  getCountryCode : async (req, res) => {
  try {
    const { cid } = req.params;
    const pool = await poolPromise;

    const result = await pool.request()
      .query(`SELECT CCode FROM COUNTRY WHERE CID = ${cid}`);

    return res.json({
      status: true,
      code: result.recordset[0]?.CCode || ""
    });

  } catch (err) {
    return res.json({
      status: false,
      message: err.message
    });
  }
  },

  registerUser: async (req, res) => {
    try {
      const {
        sponsorId,
        side,
        name,
        email,
        mobile,
        countryName,
        sponsorName
      } = req.body;

      const pool = await poolPromise;

      //  Validate Sponsor
      const regRes = await pool.request()
        .query(`SELECT regno FROM member_login WHERE loginid='${sponsorId}'`);

      if (!regRes.recordset.length) {
        return res.json({
          status: false,
          message: "Invalid Sponsor ID"
        });
      }

      const introRegNo = regRes.recordset[0].regno;

      //  FIX introSide (CHAR(1) issue)
      const introSide = side ? side.trim().substring(0, 1) : null;

      //  Check if email or mobile already exists
      const emailCheckRes = await pool.request()
        .query(`SELECT 1 FROM member_Master WHERE emailID='${email}'`);
      
      if (emailCheckRes.recordset.length > 0) {
        return res.json({
          status: false,
          message: "This email is already registered."
        });
      }

      const mobileCheckRes = await pool.request()
        .query(`SELECT 1 FROM member_Master WHERE mobile='${mobile}'`);
      
      if (mobileCheckRes.recordset.length > 0) {
        return res.json({
          status: false,
          message: "This mobile number is already registered."
        });
      }

      // PASSWORD GENERATION
      const upper = "ABCDEFGHJKMNOPQRSTUVWXYZ";
      const lower = "abcdefghjkmnopqrstuvwxyz";
      const digits = "0123456789";
      const special = "@$!%*?&";
      const all = upper + lower + digits + special;

      let pass = [
        upper[Math.floor(Math.random() * upper.length)],
        lower[Math.floor(Math.random() * lower.length)],
        digits[Math.floor(Math.random() * digits.length)],
        special[Math.floor(Math.random() * special.length)]
      ];

      while (pass.length < 10) {
        pass.push(all[Math.floor(Math.random() * all.length)]);
      }

      const password = pass.sort(() => Math.random() - 0.5).join("");

      //  SECURE HASH
      const encPass = HashingHelper.encrypt(password);

      //  CALL STORED PROCEDURE
      const request = pool.request();
      request.input("introRegNo", sql.Int, introRegNo);
      request.input("introSide", sql.Char(1), introSide);
      request.input("fName", sql.VarChar(100), name);
      request.input("lname", sql.VarChar(100), "");
      request.input("mobile", sql.VarChar(20), mobile);
      request.input("email", sql.VarChar(100), email);
      request.input("loginid", sql.VarChar(50), "###");
      request.input("pass", sql.VarChar(sql.MAX), encPass);
      request.input("Tranpass", sql.VarChar(sql.MAX), encPass);
      request.input("address", sql.VarChar(255), "");
      request.input("country", sql.VarChar(100), countryName);
      request.input("affiliate_level", sql.Int, 1);
      request.input("referrer", sql.VarChar(100), sponsorName);
      request.input("referrer_id", sql.VarChar(50), sponsorId);
      request.output("intResult", sql.Int);

      const result = await request.execute("sp_InsertNetworkB");
      const newRegNo = result.output.intResult;

      if (newRegNo > 0) {
        const userRes = await pool.request()
          .query(`SELECT loginid FROM member_login WHERE regno=${newRegNo}`);

        return res.json({
          status: true,
          message: "User registered successfully",
          loginid: userRes.recordset[0].loginid,
          password: password
        });
      }

      return res.json({
        status: false,
        message: "Registration failed"
      });

    } catch (err) {
      console.error(err);
      return res.json({
        status: false,
        message: "something went wrong: " + err.message
      });
    }
  },

  getPayoutUsers: async (req, res) => {
    try {
      const pool = await poolPromise;

      // query params
      const search = req.query.search ? req.query.search.toLowerCase() : "";
      const page = parseInt(req.query.page) || 1;
      const limit = parseInt(req.query.limit) || 4;

      const offset = (page - 1) * limit;

      // call SAME procedure
      const result = await pool
        .request()
        .execute("Sp_user_PayoutBlock");

      let rows = result.recordset;

      // SEARCH FILTER (same pattern)
      if (search) {
        rows = rows.filter(r =>
          (r.loginid && r.loginid.toLowerCase().includes(search)) ||
          (r.fname && r.fname.toLowerCase().includes(search)) ||
          (r.emailid && r.emailid.toLowerCase().includes(search))
        );
      }

      const totalRecords = rows.length;

      // PAGINATION
      const paginatedData = rows.slice(offset, offset + limit);

      return res.json({
        status: true,
        message: "Payout users fetched successfully",
        pagination: {
          totalRecords,
          currentPage: page,
          totalPages: Math.ceil(totalRecords / limit),
          limit
        },
        data: paginatedData
      });

    } catch (err) {
      return res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  payoutBlockAction: async (req, res) => {
    try {
      const { regno, action } = req.body;

      if (!regno || !action) {
        return res.json({
          status: false,
          message: "regno and action are required"
        });
      }

      const pool = await poolPromise;

      let query = "";

      if (action === "block") {
        query = `UPDATE member_Master SET wbstatus=0 WHERE regno=${regno}`;
      } 
      else if (action === "unblock") {
        query = `UPDATE member_Master SET wbstatus=1 WHERE regno=${regno}`;
      } 
      else {
        return res.json({
          status: false,
          message: "Invalid action"
        });
      }

      const result = await pool.request().query(query);

      if (result.rowsAffected[0] > 0) {
        return res.json({
          status: true,
          message: action === "block"
            ? "Payout Successfully Blocked"
            : "Payout Successfully Unblocked"
        });
      }

      return res.json({
        status: false,
        message: "No record updated"
      });

    } catch (err) {
      return res.json({
        status: false,
        message: err.message
      });
    }
  },




};
