const sql = require('mssql');
const { poolPromise } = require('../config/mssql');
const { base_img_url } = require('../member_section');

function isNull(item) {
   return item !== null && item !== undefined ? item.toString() : "";
}


module.exports = {

    country_list: async (request, response) => {

        try {
            const pool = await poolPromise;
            const result = await pool.request().query(`SELECT * FROM country`);

            if (result.recordset.length > 0) {

                var res = result.recordset;
                var data = [];

                res.forEach(function (table) {
                    let country = {
                        CID: isNull(table.CID),
                        countryName: isNull(table.countryName),
                        cActive: isNull(table.cActive),
                        CCode: isNull(table.CCode)
                    };
                    data.push(country);
                });

                return response.status(201).json({ status: true, message: 'Country list Api', data: data });

            } else {
                return response.status(201).json({ status: false, message: 'Country list not found', data: []});
            }

        } catch (error) {
            return response.status(403).json({ status: false, message: error });
        }
    },

    country_details_by_CID: async (request, response) => {

        try {
            const { CID } = request.body;

            if (!CID) {
                return response.status(201).json({
                    status: false,
                    message: 'CID is required',
                    data: []
                });
            }

            const pool = await poolPromise;

            const result = await pool.request()
                .input('CID', sql.Int, CID)
                .query(`SELECT * FROM country WHERE CID = @CID`);

            if (result.recordset.length > 0) {

                var res = result.recordset;
                var data = [];

                res.forEach(function (table) {
                    let country = {
                        CID: isNull(table.CID),
                        countryName: isNull(table.countryName),
                        cActive: isNull(table.cActive),
                        CCode: isNull(table.CCode)
                    };
                    data.push(country);
                });

                return response.status(201).json({
                    status: true,
                    message: 'Country details Api',
                    data: data
                });

            } else {
                return response.status(201).json({
                    status: false,
                    message: 'Country not found',
                    data: []
                });
            }

        } catch (error) {
            return response.status(403).json({
                status: false,
                message: error
            });
        }
    },


};
