const sql = require("mssql");
const path = require("path");
const { poolPromise } = require("../config/mssql");

const SID = 29;

module.exports = {

  /* ===================== GET BONANZA IMAGE ===================== */
  getBonanzaImage: async (req, res) => {
    try {
      const pool = await poolPromise;
      const result = await pool.request()
        .input("Sid", sql.Int, SID)
        .execute("Getbonazaimage");

      const imageName = result.recordset?.[0]?.ImageFileName || "";

      res.json({
        status: true,
        message: "Bonanza image loaded",
        data: { image: imageName }
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  /* ===================== UPDATE BONANZA IMAGE ===================== */
  updateBonanzaImage: async (req, res) => {
    try {

        console.log("REQ FILE:", req.file);
      if (!req.file) {
        return res.json({
          status: false,
          message: "Image file required",
          data: []
        });
      }

    //   const fileName = "BNZ_" + req.file.originalname;
    const fileName = req.file.filename;

      const pool = await poolPromise;
      await pool.request()
        .input("ImageFileName", sql.VarChar(200), fileName)
        .input("CurrentDate", sql.VarChar(20), new Date().toISOString().slice(0, 10))
        .input("Sid", sql.Int, SID)
        .execute("UpdateSettingsbonaza");

      

      res.json({
        status: true,
        message: "Bonanza image updated successfully",
        data: { image: fileName }
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  /* ===================== GET BONANZA STATUS ===================== */
  getBonanzaStatus: async (req, res) => {
    try {
      const pool = await poolPromise;

      const result = await pool.request()
        .input("sid", sql.Int, SID)
        .query("SELECT active FROM Settings WHERE sid = @sid");

      res.json({
        status: true,
        message: "Bonanza status loaded",
        data: result.recordset[0]
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },

  /* ===================== UPDATE BONANZA STATUS ===================== */
  updateBonanzaStatus: async (req, res) => {
    try {
      const { status } = req.body;

      if (status === undefined) {
        return res.json({
          status: false,
          message: "Status required",
          data: []
        });
      }

      const pool = await poolPromise;
      await pool.request()
        .input("Status", sql.VarChar(10), status)
        .input("Sid", sql.Int, SID)
        .execute("UpdateBonanzaStatus");

      res.json({
        status: true,
        message: "Bonanza status updated",
        data: []
      });

    } catch (err) {
      res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  }

};
