const pg = require('pg');
const fs = require('fs');

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

const dbconfig = require('../db');
const pool = new pg.Pool(dbconfig);

const { base_img_url, } = require('../member_section');


module.exports = {

    banner_list: (request, response) => {        

        pool.query(`SELECT * FROM tbl_banner WHERE status = 1 order by tbl_banner_id DESC`, async(error, result) => {

            if (error) { return response.status(403).json({ status: false, message: error }) }
       
            if (result.rowCount > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_banner_id: isNull(table.tbl_banner_id),
                        title: isNull(table.title),
                        banner_image: isNull(base_img_url + "/banner_image/"+table.banner_image)
                    };
                    data.push(cat);
                });
               return response.status(201).json({ status: true, message: 'Banner list Api', data: data })

            } else {
                return response.status(201).json({ status: false, message: 'Banner list not found', data: [] })
            }
        })
    },
};