const sql = require('mssql');
const { poolPromise } = require('../config/mssql');

module.exports = {

  /* ===== GET ALL NEWS ===== */
  getNewsList: async (req, res) => {
    try {
      const pool = await poolPromise;
      const result = await pool.request()
        .query('EXEC usp_getnews');

      res.json({
        status: true,
        data: result.recordset
      });
    } catch (err) {
      res.json({ status: false, message: err.message });
    }
  },

  /* ===== ADD NEWS ===== */
  addNews: async (req, res) => {
    try {
      const { news, display } = req.body;

      const pool = await poolPromise;
      await pool.request()
        .input('news', sql.NVarChar, news)
        .input('display', sql.Int, display)
        .query(`
          INSERT INTO eventnews (news, newsdate, activeflag, display)
          VALUES (@news, GETDATE(), 1, @display)
        `);

      res.json({ status: true, message: 'News added successfully' });

    } catch (err) {
      res.json({ status: false, message: err.message });
    }
  },

  /* ===== GET SINGLE NEWS ===== */
  getNewsById: async (req, res) => {
    try {
      const pool = await poolPromise;
      const result = await pool.request()
        .input('id', sql.Int, req.params.id)
        .query('SELECT * FROM eventnews WHERE newsid=@id');

      res.json({ status: true, data: result.recordset[0] });
    } catch (err) {
      res.json({ status: false, message: err.message });
    }
  },

  /* ===== UPDATE NEWS ===== */
  updateNews: async (req, res) => {
    try {
      const { news, display } = req.body;

      const pool = await poolPromise;
      await pool.request()
        .input('news', sql.NVarChar, news)
        .input('display', sql.Int, display)
        .input('id', sql.Int, req.params.id)
        .query(`
          UPDATE eventnews 
          SET news=@news, display=@display 
          WHERE newsid=@id
        `);

      res.json({ status: true, message: 'News updated successfully' });
    } catch (err) {
      res.json({ status: false, message: err.message });
    }
  },

  /* ===== DELETE (SOFT) ===== */
  deleteNews: async (req, res) => {
    try {
      const pool = await poolPromise;
      await pool.request()
        .input('id', sql.Int, req.params.id)
        .query('UPDATE eventnews SET activeflag=0 WHERE newsid=@id');

      res.json({ status: true, message: 'News deleted' });
    } catch (err) {
      res.json({ status: false, message: err.message });
    }
  }

};
