const sql = require('mssql');
const { poolPromise } = require("../config/mssql");

module.exports = {

  // 🔹 GET BANK DETAILS
  get_bank_details_API: async (req, res) => {
    try {
      const pool = await poolPromise;

      const result = await pool.request()
        .execute('SPgetBankDetails');

      if (result.recordset.length > 0) {
        return res.status(200).json({
          status: true,
          message: 'Bank details fetched successfully',
          data: result.recordset[0]
        });
      } else {
        return res.status(200).json({
          status: false,
          message: 'No bank details found',
          data: []
        });
      }

    } catch (err) {
      return res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  },


  // 🔹 UPDATE BANK DETAILS
  update_bank_details_API: async (req, res) => {
    try {

      const { bankName, accHolder, accNumber, ifsc } = req.body;

      if (!bankName || !accHolder || !accNumber || !ifsc) {
        return res.status(200).json({
          status: false,
          message: 'All fields are required',
          data: []
        });
      }

      const pool = await poolPromise;

      const result = await pool.request()
        .input('BankName', sql.VarChar(100), bankName)
        .input('AccHolder', sql.VarChar(100), accHolder)
        .input('AccNumber', sql.VarChar(100), accNumber)
        .input('Ifsc', sql.VarChar(100), ifsc)
        .output('intResult', sql.Int)
        .execute('sp_UpdateBankDetails');

      const intResult = result.output.intResult;

      if (intResult > 0) {
        return res.status(200).json({
          status: true,
          message: 'Bank Details Updated Successfully',
          data: []
        });
      } else {
        return res.status(200).json({
          status: false,
          message: 'Error detected, Please contact support',
          data: []
        });
      }

    } catch (err) {
      return res.status(500).json({
        status: false,
        message: err.message,
        data: []
      });
    }
  }

};
