const sql = require('mssql');
const { poolPromise } = require('../config/mssql');
const nodemailer = require('nodemailer');

/* helper */
function generateOTP() {
  return Math.floor(100000 + Math.random() * 900000).toString();
}

module.exports = {

  /* ================= SEND OTP ================= */
  send_admin_otp: async (req, res) => {
    try {
      const { username, password } = req.body;

      if (!username || !password) {
        return res.json({ status: false, message: 'Username & Password required' });
      }

      const otp = generateOTP();
      req.session.ADMIN_OTP = otp;
      req.session.ADMIN_LOGIN = { username, password };

      /* MAIL */
      const transporter = nodemailer.createTransport({
        service: 'gmail',
        auth: {
          user: 'YOUR_MAIL@gmail.com',
          pass: 'APP_PASSWORD'
        }
      });

      await transporter.sendMail({
        from: 'Prime Trade',
        to: 'azamkh8811@gmail.com', // DB se bhi nikal sakte ho
        subject: 'OTP for Admin Login',
        html: `<h3>Your OTP is : <b>${otp}</b></h3>`
      });

      return res.json({
        status: true,
        message: 'OTP sent to registered email'
      });

    } catch (err) {
      return res.json({ status: false, message: err.message });
    }
  },

  /* ================= VERIFY OTP + LOGIN ================= */
  admin_login_verify: async (req, res) => {
    try {
      const { otp } = req.body;

      if (!otp) {
        return res.json({ status: false, message: 'OTP required' });
      }

      if (req.session.ADMIN_OTP !== otp) {
        return res.json({ status: false, message: 'Invalid OTP' });
      }

      const { username, password } = req.session.ADMIN_LOGIN;

      const pool = await poolPromise;
      const result = await pool.request()
        .input('UserName', sql.VarChar(100), username)
        .input('Password', sql.VarChar(100), password)
        .input('QueryType', sql.VarChar(20), 'GetUserDetails')
        .execute('uspLogin');

      if (result.recordset.length === 0) {
        return res.json({ status: false, message: 'Invalid username or password' });
      }

      req.session.ADMIN = result.recordset[0];

      return res.json({
        status: true,
        message: 'Login successful'
      });

    } catch (err) {
      return res.json({ status: false, message: err.message });
    }
  }

};
