// const express = require('express');
// const cors = require('cors');
// const sql = require('mssql');
// const dbconfig = require('./db');
// const path = require('path');
// const app = express();
// const port = 3001;


// // const cors = require("cors");

// app.use(cors({
//   origin: "http://localhost:3000",
//   credentials: true
// }));


// app.use(function (req, res, next) {
//     res.setHeader('Access-Control-Allow-Origin', '*');
//     res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
//     res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
//     res.setHeader('Access-Control-Allow-Credentials', true);
//     next();
// });


// app.use(function(req, res, next) {
//     res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
//     res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
//     next();
// });

// app.use(cors());
// app.use(express.json()); 
// app.use(express.urlencoded({ extended: true })); 


// const checkauth = require('./api/auth/jwt_auth');
// const validation = require('./api/middleware/validation');

// app.use(express.static(path.join(__dirname, 'views')));

// const base_url = `http://localhost:${port}`;
// const base_img_url = `http://localhost:${port}/files/upload`;


// module.exports = { base_img_url : base_img_url}


// app.get('/member_section', (req, res) => {
//     res.send('Welcome to the Prime trade api Section!');
// });


// const userAPI = require('./api/user_data');

// // app.post('/user_data/send_otp_API', cors(), userAPI.send_otp_API);
// app.post('/user_data/admin_login_API', cors(),  userAPI.admin_login_API);

// app.post('/user_data/change-password', cors(), userAPI.change_password_API);



// // ========================== This is Master Section Routes ========================== //

// const newsCtrl = require('./api/adminNewsController');

// app.get('/adminNewsController/news', newsCtrl.getNewsList);
// app.post('/adminNewsController/news', newsCtrl.addNews);
// app.get('/adminNewsController/news/:id', newsCtrl.getNewsById);
// app.put('/adminNewsController/news/:id', newsCtrl.updateNews);
// app.delete('/adminNewsController/news/:id', newsCtrl.deleteNews);






// // For Login  otp
// // app.post('/user_data/mobile_otp_verify_API', cors(),  validation.mobile_otp_verify_val, usersAPI.mobile_otp_verify_API);

// // const bannerAPI = require('./api/banner_data');
// // app.get('/banner_data/banner_list',  cors(), bannerAPI.banner_list);

// const countryAPI = require('./api/country_data');
// app.get('/country_data/country_list',  cors(), countryAPI.country_list);
// app.post('/country_data/country_details_by_CID',  cors(), countryAPI.country_details_by_CID);
// // app.post('/category_data/subcategory_list_by_cat_id',  cors(), validation.subcategory_val, categoryAPI.subcategory_list_by_cat_id);
// // app.get('/category_data/subcategory_random_list',  cors(), categoryAPI.subcategory_random_list);


// app.listen(port, () =>{ 
//     console.log(`MLM app section listening at ${base_url}/member_section`);
// })










const express = require('express');
const cors = require('cors');
const sql = require('mssql');
const dbconfig = require('./db');
const path = require('path');

const app = express();
const port = 3002;

/* ===================== CORS (FIXED) ===================== */
const corsOptions = {
  origin: "http://localhost:3000", // React UI
  credentials: true,
  methods: ["GET", "POST", "PUT", "DELETE", "OPTIONS"],
  allowedHeaders: ["Content-Type", "Authorization"]
};

app.use('/views/files/upload', express.static(path.join(__dirname, 'views/files/upload')));
app.use("/views/files/upload", express.static("views/files/upload"));



app.use(cors(corsOptions));

/* ===================== BODY PARSER ===================== */
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

/* ===================== STATIC ===================== */
app.use(express.static(path.join(__dirname, 'views')));

/* ===================== BASE URLS ===================== */
const base_url = `http://localhost:${port}`;
const base_img_url = `http://localhost:${port}/files/upload`;

module.exports = {
  base_img_url: base_img_url
};

/* ===================== TEST ROUTE ===================== */
app.get('/member_section', (req, res) => {
  res.send('Welcome to the Prime trade api Section!');
});

/* ===================== AUTH / VALIDATION ===================== */
const checkauth = require('./api/auth/jwt_auth');
const validation = require('./api/middleware/validation');

/* ===================== USER APIs ===================== */
const userAPI = require('./api/user_data');

app.post('/user_data/admin_login_API',  userAPI.admin_login_API);
app.post('/user_data/change-password', userAPI.change_password_API);



/* ===================== BONANZA APIs ===================== */
const bonanzaAPI = require('./api/bonanza');
const bonanzaUpload = require('./api/middleware/bonanza_upload');

//for jwt auth protected routes
// app.get('/bonanza/get-image', checkauth.checkauth, bonanzaAPI.getBonanzaImage);

app.get('/bonanza/get-image', bonanzaAPI.getBonanzaImage);
app.post('/bonanza/update-image', bonanzaUpload.single('image'), bonanzaAPI.updateBonanzaImage);

app.get('/bonanza/get-status', bonanzaAPI.getBonanzaStatus);
app.post('/bonanza/update-status', bonanzaAPI.updateBonanzaStatus);




/* ===================== BANK DETAILS APIs ===================== */
const bankController = require('./api/adminBankController');

app.get('/admin/bank-details', bankController.get_bank_details_API);
app.post('/admin/bank-details/update', bankController.update_bank_details_API);


/* ===================== USDT RATE APIs ===================== */
const settingController = require('./api/masterSectionApis/settingController');
app.get('/admin/usdt-rate', settingController.get_usdt_rate_API);
app.post('/admin/usdt-rate/update', settingController.update_usdt_rate_API);


/* ===================== Customer Section APIs ===================== */
const adminController = require('./api/cutomerSectionApis/adminController');

app.get('/admin/active-deactive-users', adminController.get_active_deactive_users_API);
app.post('/admin/block-unblock-user', adminController.block_unblock_user_API);
app.post('/admin/account-statement', adminController.get_account_statement_API);
app.post('/admin/all-members', adminController.get_all_members_API);


app.post('/admin/wallet-details', adminController.get_wallet_details);

app.post('/admin/get-user-by-login', adminController.getUserByLoginId);
app.get('/admin/getIncomeBlockUsers', adminController.getIncomeBlockUsers);
app.post('/admin/incomeBlockAction', adminController.incomeBlockAction);

app.get("/user/countries", adminController.getCountries);
app.get("/user/sponsor/:loginid", adminController.validateSponsor);
app.get("/user/country-code/:cid", adminController.getCountryCode);
app.post("/user/register", adminController.registerUser);


app.get('/user/payout-action', adminController.getPayoutUsers);
app.post('/user/payout-block-action', adminController.payoutBlockAction);

/* ===================== ADMIN NEWS APIs ===================== */
const newsCtrl = require('./api/adminNewsController');

app.get('/adminNewsController/news', newsCtrl.getNewsList);
app.post('/adminNewsController/news', newsCtrl.addNews);
app.get('/adminNewsController/news/:id', newsCtrl.getNewsById);
app.put('/adminNewsController/news/:id', newsCtrl.updateNews);
app.delete('/adminNewsController/news/:id', newsCtrl.deleteNews);

/* ===================== COUNTRY APIs ===================== */
const countryAPI = require('./api/country_data');

app.get('/country_data/country_list', countryAPI.country_list);
app.post('/country_data/country_details_by_CID', countryAPI.country_details_by_CID);

/* ===================== SERVER START ===================== */
app.listen(port, () => {
  console.log(`✅ MLM app section listening at ${base_url}/member_section`);
});
